
const Sequelize = require('sequelize');
const DataTypes = Sequelize.DataTypes;

const _Address = require("./Address");
const _Attention = require("./Attention");
const _Bill = require("./Bill");
const _BloodTyping = require("./BloodTyping");
const _Boxes = require("./Boxes");
const _Cie = require("./Cie");
const _CivilStatus = require("./CivilStatus");
const _Company = require("./Company");
const _ConsultingRoom = require("./ConsultingRoom");
const _Customer = require("./Customer");
const _Diagnosis = require("./Diagnosis");
const _Diary = require("./Diary");
const _DetailBill = require("./DetailBill");
const _Disability = require("./Disability");
const _Evolution = require("./Evolution");
const _Exams = require("./Exams");
const _Gender = require("./Gender");
const _Habits = require("./Habits");
const _License = require("./License");
const _Medic_Company = require("./Medic_Company");
const _Medic = require("./Medic");
const _Menu = require("./Menu");
const _OrganSystemsReview = require("./OrganSystemsReview");
const _PathologicalBackground = require("./PathologicalBackground");
const _Patient_Cita = require("./Patient_Cita");
const _Patient = require("./Patient");
const _Phone = require("./Phone");
const _Prescription = require("./Prescription");
const _Product = require("./Product");
const _PsychologicalEvaluation = require("./PsychologicalEvaluation");
const _Patient_Company = require("./Patient_Company");
const _ReasonConsultation = require("./ReasonConsultation");
const _RecordSubsequentQueries = require("./RecordSubsequentQueries");
const _Roles = require("./Roles");
const _Sex = require("./Sex");
const _SexualOrientation = require("./SexualOrientation");
const _Specialty = require("./Specialty");
const _Tooth = require("./Tooth");
const _TreatmentPlan = require("./TreatmentPlan");
const _Type_Address_Medic = require("./Type_Address_Medic");
const _Type_Phone_Medic = require("./Type_Phone_Medic");
const _TypeExam = require("./TypeExam");
const _TypeID = require("./TypeID");
const _TypeLicense = require("./TypeLicense");
const _Users = require("./Users");
const _VitalSigns = require("./VitalSigns");

const seqOptions = {
  database_name: 'sensacio_DocExpress',
  username: 'sensacio_Pablo23',
  password: 'N[1e!zTwLcj8',
  nested: {
    host: 'localhost',
    dialect: 'mysql',
    port: 3306,
    pool: {
      max: 5,
      min: 0,
      acquire: 30000,
      idle: 10000
    },
    dialectOptions: {
      decimalNumbers: true
    }
  }
};

const sequelize = new Sequelize(
  seqOptions.database_name,
  seqOptions.username,
  seqOptions.password,
  seqOptions.nested
);

const Address = _Address(sequelize, DataTypes);
const Attention = _Attention(sequelize, DataTypes);
const Bill = _Bill(sequelize, DataTypes);
const BloodTyping = _BloodTyping(sequelize, DataTypes);
const Boxes = _Boxes(sequelize, DataTypes);
const Cie = _Cie(sequelize, DataTypes);
const CivilStatus = _CivilStatus(sequelize, DataTypes);
const Company = _Company(sequelize, DataTypes);
const ConsultingRoom = _ConsultingRoom(sequelize, DataTypes);
const Customer = _Customer(sequelize, DataTypes);
const DetailBill = _DetailBill(sequelize, DataTypes);
const Diagnosis = _Diagnosis(sequelize, DataTypes);
const Diary = _Diary(sequelize, DataTypes);
const Disability = _Disability(sequelize, DataTypes);
const Evolution = _Evolution(sequelize, DataTypes);
const Exams = _Exams(sequelize, DataTypes);
const Gender = _Gender(sequelize, DataTypes);
const Habits = _Habits(sequelize, DataTypes);
const License = _License(sequelize, DataTypes);
const Medic_Company = _Medic_Company(sequelize, DataTypes);
const Medic = _Medic(sequelize, DataTypes);
const Menu = _Menu(sequelize, DataTypes);
const OrganSystemsReview = _OrganSystemsReview(sequelize, DataTypes);
const PathologicalBackground = _PathologicalBackground(sequelize, DataTypes);
const Patient_Cita = _Patient_Cita(sequelize, DataTypes);
const Patient_Company = _Patient_Company(sequelize, DataTypes);
const Patient = _Patient(sequelize, DataTypes);
const Phone = _Phone(sequelize, DataTypes);
const Prescription = _Prescription(sequelize, DataTypes);
const Product = _Product(sequelize, DataTypes);
const PsychologicalEvaluation = _PsychologicalEvaluation(sequelize, DataTypes);
const ReasonConsultation = _ReasonConsultation(sequelize, DataTypes);
const RecordSubsequentQueries = _RecordSubsequentQueries(sequelize, DataTypes);
const Roles = _Roles(sequelize, DataTypes);
const Sex = _Sex(sequelize, DataTypes);
const SexualOrientation = _SexualOrientation(sequelize, DataTypes);
const Specialty = _Specialty(sequelize, DataTypes);
const Tooth = _Tooth(sequelize, DataTypes);
const TreatmentPlan = _TreatmentPlan(sequelize, DataTypes);
const Type_Address_Medic = _Type_Address_Medic(sequelize, DataTypes);
const Type_Phone_Medic = _Type_Phone_Medic(sequelize, DataTypes);
const TypeExam = _TypeExam(sequelize, DataTypes);
const TypeID = _TypeID(sequelize, DataTypes);
const TypeLicense = _TypeLicense(sequelize, DataTypes);
const Users = _Users(sequelize, DataTypes);
const VitalSigns = _VitalSigns(sequelize, DataTypes);

Company.hasMany(Users, {as: 'users', foreignKey:'id_user'});
Users.belongsTo(Company, {as: 'companies', foreignKey:'id_company'});

Patient.belongsToMany(Company, {as: 'companies', foreignKey:'id_patient',  through: Patient_Company});
Company.belongsToMany(Patient, {as: 'patients', foreignKey:'id_company', through: Patient_Company});

Company.hasMany(License, {as:'license', foreignKey:'id_license'});
License.belongsTo(Company, {as: 'companies', foreignKey:'id_company'});

Company.hasMany(Attention, {as:'attention', foreignKey:'id_attention'});
Attention.belongsTo(Company, {as: 'companies', foreignKey:'id_company'});

Company.hasMany(Product, {as:'products', foreignKey:'id_product'});
Product.belongsTo(Company, {as: 'companies', foreignKey:'id_company'});

TypeLicense.hasMany(License, {as:'license', foreignKey:'id_license'});
License.belongsTo(TypeLicense, {as:'type_license', foreignKey:'id_type_license'});

Company.hasMany(Boxes, {as:'boxes', foreignKey:'id_box'});
Boxes.belongsTo(Company, {as: 'companies', foreignKey:'id_company'});

Boxes.hasMany(Bill, {as:'bill', foreignKey:'id_bill'});
Bill.belongsTo(Boxes, {as: 'boxes', foreignKey:'id_box'});

Customer.hasMany(Bill, {as:'bill', foreignKey:'id_bill'});
Bill.belongsTo(Customer, {as: 'customers', foreignKey:'id_customer'});

Patient.hasMany(Attention, {as:'attention', foreignKey:'id_patient'});
Attention.belongsTo(Patient, {as:'patient', foreignKey:'id_patient'});

BloodTyping.hasMany(Patient, {as:'patient', foreignKey:'id_patient'});
Patient.belongsTo(BloodTyping, {as: 'blood_typing', foreignKey: 'id_blood_typing'});

CivilStatus.hasMany(Patient, {as:'patient', foreignKey:'id_patient'});
Patient.belongsTo(CivilStatus, {as: 'civil_status', foreignKey: 'id_civil_status'});

Disability.hasMany(Patient, {as:'patient', foreignKey:'id_patient'});
Patient.belongsTo(Disability, {as: 'disability', foreignKey: 'id_disability'});

Gender.hasMany(Patient, {as:'patient', foreignKey:'id_patient'});
Patient.belongsTo(Gender, {as: 'gender', foreignKey: 'id_gender'});

Sex.hasMany(Patient, {as:'patient', foreignKey:'id_patient'});
Patient.belongsTo(Sex, {as: 'sex', foreignKey: 'id_sex'});

SexualOrientation.hasMany(Patient, {as:'patient', foreignKey:'id_patient'});
Patient.belongsTo(SexualOrientation, {as: 'sexual_orientation', foreignKey: 'id_sexual_orientation'});

Roles.hasMany(Users, {as:'user', foreignKey:'id_user'});
Users.belongsTo(Roles, {as: 'rol', foreignKey:'id_role'});

Bill.hasMany(DetailBill, {as: 'detail_bill', foreignKey: 'id_detail'});
DetailBill.belongsTo(Bill, {as: 'bills', foreignKey: 'id_bill'});

Product.hasMany(DetailBill, {as:'detail_bill', foreignKey:'id_detail'});
DetailBill.belongsTo(Product, {as: 'products', foreignKey: 'id_product'});

Attention.hasMany(Prescription, {as:'prescription', foreignKey:'id_prescription'});
Prescription.belongsTo(Attention, {as: 'attentions', foreignKey:'id_attention'});

Attention.hasMany(Evolution, {as:'evolution', foreignKey:'id_evolution'});
Evolution.belongsTo(Attention, {as: 'attention', foreignKey:'id_attention'});

Company.hasMany(ConsultingRoom, {as: 'consulting', foreignKey:'id_consulting'});
ConsultingRoom.belongsTo(Company, {as:'company', foreignKey:'id_company'});

Medic.belongsToMany(Company, {as: 'companies', foreignKey:'id_medic',  through: Medic_Company});
Company.belongsToMany(Medic, {as: 'medics', foreignKey:'id_company', through: Medic_Company});

Medic.hasMany(Diary, {as:'diary', foreignKey: 'id_doc'});
Diary.belongsTo(Medic, {as:'medic', foreignKey: 'id_doc'});

ConsultingRoom.hasMany(Diary, {as:'diary', foreignKey: 'id_consul'});
Diary.belongsTo(ConsultingRoom, {as:'consulting_room', foreignKey: 'id_consul'});

Diary.hasMany(Patient_Cita, {as: 'patient_cita', foreignKey:'id_diary'});
Patient_Cita.belongsTo(Diary, {as: 'diary', foreignKey:'id_diary'});


const db = {};
db.Sequelize = Sequelize;
db.sequelize = sequelize;

db.Address = Address;
db.Attention = Attention;
db.Bill = Bill;
db.BloodTyping = BloodTyping;
db.Boxes = Boxes;
db.Cie = Cie;
db.CivilStatus = CivilStatus;
db.Company = Company;
db.ConsultingRoom = ConsultingRoom;
db.Customer = Customer;
db.DetailBill = DetailBill;
db.Diagnosis = Diagnosis;
db.Diary = Diary;
db.Disability = Disability;
db.Evolution = Evolution;
db.Exams = Exams;
db.Gender = Gender;
db.Habits = Habits;
db.License = License;
db.Medic_Company = Medic_Company;
db.Medic = Medic;
db.Menu = Menu;
db.OrganSystemsReview = OrganSystemsReview;
db.PathologicalBackground = PathologicalBackground;
db.Patient_Cita = Patient_Cita;
db.Patient_Company = Patient_Company;
db.Patient = Patient;
db.Phone = Phone;
db.Prescription = Prescription;
db.Product = Product;
db.PsychologicalEvaluation = PsychologicalEvaluation;
db.ReasonConsultation = ReasonConsultation;
db.RecordSubsequentQueries = RecordSubsequentQueries;
db.Roles = Roles;
db.Sex = Sex;
db.SexualOrientation = SexualOrientation;
db.Specialty = Specialty;
db.Tooth = Tooth;
db.TreatmentPlan = TreatmentPlan;
db.Type_Address_Medic = Type_Address_Medic;
db.Type_Phone_Medic = Type_Phone_Medic;
db.TypeExam = TypeExam;
db.TypeID = TypeID;
db.TypeLicense = TypeLicense;
db.Users = Users;
db.VitalSigns = VitalSigns;

module.exports = {
  db
}