const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Users', {
    id_user: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_role: {
      type: DataTypes.SMALLINT,
      allowNull: false
    },
    id_company: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    email: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Correo electrónico de usuario para el ingreso de a la aplicación"
    },
    user_password: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Contraseña de usuario para el ingreso de a la aplicación"
    },
    name_person: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Nombre de usuario de la aplicación"
    },
    address_person: {
      type: DataTypes.STRING(2000),
      allowNull: false,
      comment: "Nombre de usuario de la aplicación"
    },
    phone_person: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Nombre de usuario de la aplicación"
    },
    img: {
      type: DataTypes.STRING(200),
      allowNull: false,
      defaultValue: "",
      comment: "Imagen de cada uno de los usuarios."
    },
    status_user: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    },
    specialty: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: "",
      comment: "Columna para la especialidad del médico"
    },
    document_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "",
      comment: "Cédula de identidad del médico"
    },
    unicodigo: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "",
      comment: "Código único que entrega el MSP a cada médico"
    }
  }, {
    sequelize,
    tableName: 'Users',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_user" },
        ]
      },
      {
        name: "FK_role_id_role",
        using: "BTREE",
        fields: [
          { name: "id_role" },
        ]
      },
      {
        name: "FK_company_id_company",
        using: "BTREE",
        fields: [
          { name: "id_company" },
        ]
      },
    ]
  });
};
