const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('TreatmentPlan', {
    id_treatment_plan: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_attention: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    treatment_plan: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Detalle del Plan de tratamiento que el médico determina."
    },
    status_treatment_plan: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'TreatmentPlan',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_treatment_plan" },
        ]
      },
      {
        name: "FK_attention_id_attention",
        using: "BTREE",
        fields: [
          { name: "id_attention" },
        ]
      },
      {
        name: "FK_user_id_user",
        using: "BTREE",
        fields: [
          { name: "id_user" },
        ]
      },
    ]
  });
};
