const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Roles', {
    id_role: {
      autoIncrement: true,
      type: DataTypes.SMALLINT,
      allowNull: false,
      primaryKey: true
    },
    detail: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Nombre del rol que se crea"
    },
    description_role: {
      type: DataTypes.STRING(300),
      allowNull: false,
      comment: "Descripción del rol detalla el perfil y los accesos que se puede otorgar"
    },
    status_role: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false,
      comment: "se registra el id del usuario que esta creando el registro"
    }
  }, {
    sequelize,
    tableName: 'Roles',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_role" },
        ]
      },
    ]
  });
};
