const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Product', {
    id_product: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_company: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    detail: {
      type: DataTypes.STRING(1500),
      allowNull: false,
      comment: "Detalle o nombre del producto"
    },
    price: {
      type: DataTypes.DECIMAL(18,4),
      allowNull: false,
      comment: "Precio unitario del producto"
    },
    iva: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      comment: "Si el producto paga impuestos 1 si no paga 0"
    },
    status_product: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Product',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_product" },
        ]
      },
      {
        name: "FK_company_id_company",
        using: "BTREE",
        fields: [
          { name: "id_company" },
        ]
      },
    ]
  });
};
