const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Prescription', {
    id_prescription: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_attention: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    medical: {
      type: DataTypes.STRING(1000),
      allowNull: false,
      comment: "Se ingresa el nombre del medicamento asi como su concentración, forma farmacéutica y la cantidad."
    },
    prescriber: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Se ingresa la prescripción completa del medicamento recetado."
    },
    warning: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "",
      comment: "Se ingresa solo de ser necesario una observación del medicamento"
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    status_prescription: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Prescription',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_prescription" },
        ]
      },
    ]
  });
};
