const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Patient_Company', {
    id_patient_company: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_patient: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_company: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Patient_Company',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_patient_company" },
        ]
      },
      {
        name: "FK_patient_id_patient",
        using: "BTREE",
        fields: [
          { name: "id_patient" },
        ]
      },
      {
        name: "FK_company_id_company",
        using: "BTREE",
        fields: [
          { name: "id_company" },
        ]
      },
    ]
  });
};
