const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('PathologicalBackground', {
    id_pathological_background: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_patient: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    type_background: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      comment: "define si el antecedente ingresado es personal (1) o familiar (2)."
    },
    detail: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Detalla el antecedente que se presenta al  médico."
    },
    status_pathological_background: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'PathologicalBackground',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_pathological_background" },
        ]
      },
      {
        name: "FK_patient_id_patient",
        using: "BTREE",
        fields: [
          { name: "id_patient" },
        ]
      },
      {
        name: "FK_user_id_user",
        using: "BTREE",
        fields: [
          { name: "id_user" },
        ]
      },
    ]
  });
};
