const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('OrganSystemsReview', {
    id_organ_systems_review: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_patient: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    type_background: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      comment: "define si el campo ingresado es revisión de órganos (1), examen físico regional (2) o examen físico sistémico (3)."
    },
    detail: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Detalla el antecedente que se presenta al  médico."
    },
    status_organ_systems_review: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'OrganSystemsReview',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_organ_systems_review" },
        ]
      },
      {
        name: "FK_patient_id_patient",
        using: "BTREE",
        fields: [
          { name: "id_patient" },
        ]
      },
      {
        name: "FK_user_id_user",
        using: "BTREE",
        fields: [
          { name: "id_user" },
        ]
      },
    ]
  });
};
