const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Menu', {
    id_menu: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    rout: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Ruta a la cual apunta el menú o el sub-menú"
    },
    detail: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Nombre del menú para poder acceder a las diferentes pantallas"
    },
    icon: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Ícono del menú para que vea en el front este solo aplica a los menú principales"
    },
    description_menu: {
      type: DataTypes.STRING(300),
      allowNull: false,
      comment: "Detalle del acceso a los cuales se puede ir desde esta ruta"
    },
    status_menu: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Menu',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_menu" },
        ]
      },
    ]
  });
};
