const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Medic_Company', {
    id_medic_company: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_medic: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_company: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Medic_Company',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_medic_company" },
        ]
      },
      {
        name: "FK_medic_id_medic",
        using: "BTREE",
        fields: [
          { name: "id_medic" },
        ]
      },
      {
        name: "FK_company_id_company",
        using: "BTREE",
        fields: [
          { name: "id_company" },
        ]
      },
    ]
  });
};
