const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Medic', {
    id_medic: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_specialty: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      comment: "Id de la especialidad médica registrada en el sistema."
    },
    id_civil_status: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      comment: "Id del estado civil del médico."
    },
    document_number: {
      type: DataTypes.STRING(10),
      allowNull: false,
      comment: "Número de identificación (cédula de identidad)."
    },
    doctor_name: {
      type: DataTypes.STRING(500),
      allowNull: false,
      comment: "Nombre completo del médico."
    },
    email: {
      type: DataTypes.STRING(500),
      allowNull: false,
      comment: "Correo electrónico del médico."
    },
    birthday_Doctor: {
      type: DataTypes.DATEONLY,
      allowNull: false,
      comment: "Fecha de nacimiento."
    },
    status_medical: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0."
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Medic',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_medic" },
        ]
      },
      {
        name: "FK_specialty_id_specialty",
        using: "BTREE",
        fields: [
          { name: "id_specialty" },
        ]
      },
    ]
  });
};
