const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Exams', {
    id_exams: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_attention: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    exam_type: {
      type: DataTypes.STRING(50),
      allowNull: false,
      comment: "El tipo de examen que fue solicitado."
    },
    exam_detail: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Detalle del Plan de tratamiento que el médico determina."
    },
    exam_url: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Detalle del Plan de tratamiento que el médico determina."
    },
    status_exams: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Exams',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_exams" },
        ]
      },
      {
        name: "FK_attention_id_attention",
        using: "BTREE",
        fields: [
          { name: "id_attention" },
        ]
      },
      {
        name: "FK_user_id_user",
        using: "BTREE",
        fields: [
          { name: "id_user" },
        ]
      },
    ]
  });
};
