const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Diary', {
    id_diary: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    title: {
      type: DataTypes.STRING(5000),
      allowNull: false,
      comment: "Todo lo ingresado por el usuario."
    },
    startDate: {
      type: DataTypes.DATE,
      allowNull: false,
      comment: "Fecha y hora de inicio la cita médica."
    },
    endDate: {
      type: DataTypes.DATE,
      allowNull: false,
      comment: "Fecha y hora de fin la cita médica."
    },
    id_user: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_company: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_doc: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_consul: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    status_diary: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Diary',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_diary" },
        ]
      },
    ]
  });
};
