const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Customer', {
    id_customer: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_type_id: {
      type: DataTypes.SMALLINT,
      allowNull: false
    },
    number_document: {
      type: DataTypes.STRING(20),
      allowNull: false,
      comment: "Número de secuencia con el que va salir la factura"
    },
    name_customer: {
      type: DataTypes.STRING(500),
      allowNull: false,
      comment: "Nombre de cliente al que va salir la factura"
    },
    address_customer: {
      type: DataTypes.STRING(1500),
      allowNull: false,
      comment: "Dirección de cliente al que va salir la factura"
    },
    email_customer: {
      type: DataTypes.STRING(100),
      allowNull: false,
      comment: "Correo electrónico de cliente al que va salir la factura"
    },
    phone_customer: {
      type: DataTypes.STRING(20),
      allowNull: false,
      comment: "Teléfono de cliente al que va salir la factura"
    },
    status_customer: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Customer',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_customer" },
        ]
      },
      {
        name: "FK_typeID_id_type_id",
        using: "BTREE",
        fields: [
          { name: "id_type_id" },
        ]
      },
    ]
  });
};
