const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Cie', {
    id_cie: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    three_characters: {
      type: DataTypes.STRING(3),
      allowNull: true,
      comment: "Se ingresa los 3 caracteres del código CIE-10 que es le principal"
    },
    main_name: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      comment: "Se ingresa el nombre principal del CIE-10."
    },
    four_characters: {
      type: DataTypes.STRING(4),
      allowNull: true,
      comment: "Se ingresa los 4 caracteres del código CIE-10 que es le secundario"
    },
    secondary_name: {
      type: DataTypes.STRING(5000),
      allowNull: true,
      comment: "Se ingresa el nombre secundaria del CIE-10."
    },
    status_cie: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Cie',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_cie" },
        ]
      },
    ]
  });
};
