const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Boxes', {
    id_box: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_company: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    box_address: {
      type: DataTypes.STRING(300),
      allowNull: false,
      comment: "Dirección de la ubicación en la que se encuentra la caja"
    },
    establishment_code: {
      type: DataTypes.STRING(3),
      allowNull: false,
      comment: "Código único de establecimiento otorgado por le SRI"
    },
    emission_point: {
      type: DataTypes.STRING(3),
      allowNull: false,
      comment: "Código único del punto de emisión"
    },
    sequence_box: {
      type: DataTypes.BIGINT,
      allowNull: false,
      comment: "Número de secuencia que le toca."
    },
    environment_type: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 ambiente de pruebas 2 ambiente de producción"
    },
    status_box: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Boxes',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_box" },
        ]
      },
      {
        name: "FK_company_id_company",
        using: "BTREE",
        fields: [
          { name: "id_company" },
        ]
      },
    ]
  });
};
