const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('Address', {
    id_address: {
      autoIncrement: true,
      type: DataTypes.BIGINT,
      allowNull: false,
      primaryKey: true
    },
    id_medic: {
      type: DataTypes.BIGINT,
      allowNull: false
    },
    id_type: {
      type: DataTypes.SMALLINT,
      allowNull: false
    },
    address_medic: {
      type: DataTypes.STRING(200),
      allowNull: false,
      comment: "Dirección completa con calles y número."
    },
    reference: {
      type: DataTypes.STRING(500),
      allowNull: false,
      comment: "Referencia de la Dirección."
    },
    status_address: {
      type: DataTypes.SMALLINT,
      allowNull: false,
      defaultValue: 1,
      comment: "Estado activo 1 inactivo 0 para tener el control de los datos de esta tabla"
    },
    create_time: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP'),
      comment: "Fecha y hora en la que se creo el registro"
    }
  }, {
    sequelize,
    tableName: 'Address',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "id_address" },
        ]
      },
      {
        name: "FK_medic_id_medic",
        using: "BTREE",
        fields: [
          { name: "id_medic" },
        ]
      },
      {
        name: "FK_type_Address_Medic_id_type",
        using: "BTREE",
        fields: [
          { name: "id_type" },
        ]
      },
    ]
  });
};
