const {Router} = require('express');
const { getAddress,
    getPhone,
    postAddress,
    postPhone,
    getSpecialty,
    postSpecialty
  } = require('../controllers/types.controller');
const { validateJWT } = require('../middlewares/validate-JWT');


const router = Router();
/* *************************************************************** */
/* **********************Services GET***************************** */

  router.get('/', validateJWT, getAddress);
  router.get('/phone', validateJWT, getPhone);
  router.get('/types/specialty', validateJWT, getSpecialty);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

  router.post('/', validateJWT, postAddress);
  router.post('/phone', validateJWT, postPhone);
  router.post('/types/specialty', validateJWT, postSpecialty);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

  // router.put('/:id', Object);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

  // router.delete('/:id', Object);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = router;
/* *************************************************************** */
/* *************************************************************** */