const {Router} = require('express');
const { getTypeID, postTypeId, putTypeId, deleteTypeId } = require('../controllers/typeID.controller');
const { validateJWT } = require('../middlewares/validate-JWT');


const router = Router();
/* *************************************************************** */
/* **********************Services GET***************************** */

  router.get('/', validateJWT, getTypeID);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

  router.post('/', validateJWT, postTypeId);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

  router.put('/:id', validateJWT, putTypeId);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

  router.delete('/:id', validateJWT, deleteTypeId);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = router;
/* *************************************************************** */
/* *************************************************************** */