const {Router} = require('express');
const { validateJWT } = require('../middlewares/validate-JWT');

const { getAttentionByPatient, 
        getAttention, 
        getAttentionByPatientByDate, 
        getAttentionTotal, 
        getTotal,
        getPatientByAttention,
        getLikePatientAttention} = require('../controllers/report.controller');


const router = Router();
/* *************************************************************** */
/* **********************Services GET***************************** */

  router.get('/:id', validateJWT, getAttentionByPatient);
  router.get('/total/:id', validateJWT, getAttentionTotal);
  router.get('/date/:start/:end', validateJWT, getAttentionByPatientByDate);
  router.get('/attention/total/byId/:attention', validateJWT, getTotal);
  router.get('/patient/attention/by/user/company', validateJWT, getPatientByAttention)
  router.get('/patient/attention/by/user/company/like/:id', validateJWT, getLikePatientAttention)

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

  router.post('/', Object);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

  router.put('/:id', Object);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

  router.delete('/:id', Object);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = router;
/* *************************************************************** */
/* *************************************************************** */