const {Router} = require('express');
const { getPlan, postPlan, putPlan, deletePlan } = require('../controllers/plan.controller');
const { validateJWT } = require('../middlewares/validate-JWT');


const router = Router();
/* *************************************************************** */
/* **********************Services GET***************************** */

  router.get('/:id', validateJWT, getPlan);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

  router.post('/', validateJWT, postPlan);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

  router.put('/:id', validateJWT, putPlan);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

  router.delete('/:id', validateJWT, deletePlan);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = router;
/* *************************************************************** */
/* *************************************************************** */