const {Router} = require('express');
const { getPathological, postPathological, putPathological, deletePathological } = require('../controllers/pathological.controller');
const { validateJWT } = require('../middlewares/validate-JWT');


const router = Router();
/* *************************************************************** */
/* **********************Services GET***************************** */

  router.get('/:id', validateJWT, getPathological);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

  router.post('/', validateJWT, postPathological);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

  router.put('/:id', validateJWT, putPathological);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

  router.delete('/:id', validateJWT, deletePathological);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = router;
/* *************************************************************** */
/* *************************************************************** */