const {request} = require('express');

const {Router} = require('express');
const { check } = require('express-validator');

const { validateJWT } = require('../middlewares/validate-JWT');
const { validateFields } = require('../middlewares/validate-fields');
const { validRoleChangesAdmin } = require('../helpers/db-validators');

const { getBoxes, postBox, deleteBox } = require('../controllers/boxes.controller');

const req = request;

const router = Router();
/* *************************************************************** */
/* **********************Services GET***************************** */

  router.get('/', [
      validateJWT
  ], getBoxes);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

  router.post('/', [
      validateJWT,
      check(req.role).custom(validRoleChangesAdmin),
      validateFields
  ], postBox);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

  // router.put('/:id', Object);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

  router.delete('/:id', [
    validateJWT,
    check(req.role).custom(validRoleChangesAdmin),
    validateFields
], deleteBox);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = router;
/* *************************************************************** */
/* *************************************************************** */