const {Router} = require('express');
const { 
  postAttention, 
  getAttentions, 
  getAttentionActivate, 
  getTotalAttention, 
  putAttention, 
  getAttentionWeek
} = require('../controllers/attention.controller');
const { validateJWT } = require('../middlewares/validate-JWT');


const router = Router();
/* *************************************************************** */
/* **********************Services GET***************************** */

  router.get('/:id', validateJWT, getAttentions);
  router.get('/activity/:id', validateJWT, getAttentionActivate);
  router.get('/total/attention/:id', validateJWT, getTotalAttention);
  router.get('/total/attentionByTime', validateJWT, getAttentionWeek);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

  router.post('/', validateJWT, postAttention);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

  router.put('/', validateJWT, putAttention);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

  // router.delete('/:id', validateJWT, deleteAttention);
/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = router;
/* *************************************************************** */
/* *************************************************************** */