const {db} = require('../tables_db/init-models');
const { format, parseISO } = require('date-fns');
const { es } = require('date-fns/locale');

const Role = db.Roles;

const validRole = async(rol = 0) => {
    const existeRol = await Role.findByPk( rol );
    if ( !existeRol ) {
        throw new Error(`El Rol que se asigno al usuario no existe.`)
    }
}

const validRoleChangesAdmin = async(rol = 0) => {
    const existeRol = await Role.findByPk( 1 );
    if(existeRol){
        if ( existeRol.detail !==  'Super Administrador') {
            throw new Error(`Ud no tiene permiso para realizar esta acción.`)
        }
    }else{
        throw new Error(`Ud no tiene permiso para realizar esta acción.`)
    }
}

const validRoleChanges = async(rol = 0) => {
    const existeRol = await Role.findByPk( rol );
    if(existeRol){
        if ( existeRol.detail !==  'Super Administrador' && existeRol.detail !== 'Super Usuario') {
            throw new Error(`Ud no tiene permiso para realizar esta acción.`)
        }
    }else{
        throw new Error(`Ud no tiene permiso para realizar esta acción.`)
    }
}

// Función para convertir una fecha a letras en español
const fechaEnLetras = async(fechaString) => {
    // Parsea la cadena de fecha al objeto Date
    const fecha = parseISO(fechaString);
    // Obtiene el día, el mes y el año en formato numérico
    const dia = parseInt(fechaString.getDate());
    const año = parseInt(fechaString.getFullYear());
    // Convierte el día y el año a letras
    const diaEnLetras = await numeroEnLetras(dia);
    const añoEnLetras = await numeroEnLetras(año);

    // Formatea el mes en letras y en mayúsculas
    const mesEnLetras = format(fechaString, 'MMMM', { locale: es }).toUpperCase();

    // Construye la cadena final con el formato deseado
    const fechaFormateada = `${diaEnLetras} DE ${mesEnLetras} DE ${añoEnLetras}`;

    return fechaFormateada;

}

const numeroEnLetras = (numero) => {
    const unidades = ['', 'UNO', 'DOS', 'TRES', 'CUATRO', 'CINCO', 'SEIS', 'SIETE', 'OCHO', 'NUEVE'];
    const decenas = ['DIEZ', 'ONCE', 'DOCE', 'TRECE', 'CATORCE', 'QUINCE', 'DIECISÉIS', 'DIECISIETE', 'DIECIOCHO', 'DIECINUEVE'];
    const decenasGenericas = ['', '', 'VEINTE', 'TREINTA', 'CUARENTA', 'CINCUENTA', 'SESENTA', 'SETENTA', 'OCHENTA', 'NOVENTA'];
    const centenas = ['', 'CIEN', 'DOCIENTOS', 'TRECIENTOS', 'CUATROCIENTOS', 'QUINIENTOS', 'SEISCIENTOS', 'SETECIENTOS', 'OCHOCIENTOS', 'NOVECIENTOS']
    const milesGenericos = ['', 'MIL', 'DOS MIL', 'TRES MIL', 'CUATRO MIL', 'CINCO MIL', 'SEIS MIL', 'SIETE MIL', 'OCHO MIL', 'NUEVE MIL'];

    if (numero < 10) {
        return unidades[numero];
    } else if (numero < 20) {
        return decenas[numero - 10];
    } else if (numero < 100) {
        const decenas = Math.floor(numero/10);
        const unidad = numero % 10;
        if(unidad === 0){
            return `${decenasGenericas[decenas]}`;
        }else{
            return `${decenasGenericas[decenas]} Y ${unidades[unidad]}`;
        }
    } else if (numero < 1000) {
        const centenasG = Math.floor(numero / 100);
        const residuo = numero % 100;

        if (residuo === 0) {
        return `${centenas[centenasG]}`;
        } else if(residuo < 10 && centenasG === 1){
            return `CIENTO ${unidades[residuo]}`
        } else {
        return `${centenas[centenasG]} ${unidades[residuo]}`;
        }
    } else {
        const miles = Math.floor(numero / 1000);
        const residuoMiles = numero % 1000;

        if (residuoMiles === 0) {
        return `${milesGenericos[miles]}`;
        } else {
        return `${milesGenericos[miles]} ${numeroEnLetras(residuoMiles)}`;
        }
    }
};

module.exports = {
    validRole,
    validRoleChangesAdmin,
    validRoleChanges,
    fechaEnLetras,
    numeroEnLetras
}