const { response, request } = require("express");
const { v4: uuidv4 } = require('uuid');
const { updateImage } = require("../helpers/update-img");
const path = require('path');
const fs = require('fs');

const fileUpload = ( req=request, res=response) => {

  const {types, id} = req.params;

  const validType = ['companies', 'patient', 'users', 'pdf'];

  if (!validType.includes(types)) {
    return res.status(401).json({
      ok:false,
      message: "No es un tipo de archivo valido."
    })
  };

  if (!req.files || Object.keys(req.files).length === 0) {
    return res.status(400).json({
      ok:false,
      msg:'No existen archivo para cargar.'
    });
  }

  const file = req.files.image;

  const cutName = file.name.split('.');
  const fileExtend = cutName[cutName.length - 1];

  const validExt = ['png', 'jpg', 'jpeg', 'gif'];
  if(!validExt.includes(fileExtend)){
    return res.status(400).json({
      ok:false,
      message: "No es una extensión del archivo valido."
    });
  }

  const fileName = `${uuidv4()}.${fileExtend}`

  const path = `./uploads/${types}/${fileName}`;

  file.mv( path, (err) => {
    if(err){
      console.log(err);
      return res.status(500).json({
        ok: false,
        msg: 'No se pudo subir la imagen.'
      });
    }

    updateImage(types, id, fileName);

    res.json({
      ok:true,
      msg: 'Imagen subida con éxito.',
      fileName
    });
  })


}

const fileUploadPDF = ( req=request, res=response) => {

  const {types, id} = req.params;

  const validType = ['companies', 'patient', 'users', 'pdf'];

  if (!validType.includes(types)) {
    return res.status(401).json({
      ok:false,
      message: "No es un tipo de archivo valido."
    })
  };

  if (!req.files || Object.keys(req.files).length === 0) {
    return res.status(400).json({
      ok:false,
      msg:'No existen archivo para cargar.'
    });
  }

  const file = req.files.file;

  const cutName = file.name.split('.');
  const fileExtend = cutName[cutName.length - 1];

  const validExt = ['pdf'];
  if(!validExt.includes(fileExtend)){
    return res.status(400).json({
      ok:false,
      message: "No es una extensión del archivo valido."
    });
  }

  const fileName = `${uuidv4()}.${fileExtend}`

  const path = `./uploads/${types}/${fileName}`;

  file.mv( path, (err) => {
    if(err){
      console.log(err);
      return res.status(500).json({
        ok: false,
        msg: 'No se pudo subir el archivo'
      });
    }

    updateImage(types, id, fileName);

    res.json({
      ok:true,
      msg: 'Archivo subido con éxito.',
      fileName
    });
  })
}

const returnImage = ( req, res = response ) => {

  const type = req.params.type;
  const photo = req.params.photo;

  const pathImg = path.join( __dirname, `../uploads/${ type }/${ photo }` );

  // imagen por defecto
  if ( fs.existsSync( pathImg ) ) {
      res.sendFile( pathImg );
  } else {
      const pathImg = path.join( __dirname, `../uploads/no-image.png` );
      res.sendFile( pathImg );
  }

}

module.exports = {
  fileUpload,
  returnImage,
  fileUploadPDF
}