const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Type_Address_Medic = db.Type_Address_Medic;
const Type_Phone_Medic = db.Type_Phone_Medic;
const Specialty = db.Specialty;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getAddress = async (req = request, res = response ) => { 
  try {

  const address = await Type_Address_Medic.findAll({
    where: {
      status_type: 1
    }
  });

  return res.json({
    ok: true,
    address
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

const getPhone = async (req = request, res = response ) => { 
  try {

  const phone = await Type_Phone_Medic.findAll({
    where: {
      status_type: 1
    }
  });

  return res.json({
    ok: true,
    phone
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

const getSpecialty = async (req = request, res = response ) => { 
  try {

  const specialty = await Specialty.findAll({
    where: {
      status_specialty: 1
    }
  });

  return res.json({
    ok: true,
    specialty
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postAddress = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    //Validar que no exista otra data igual
    const existData = await Type_Address_Medic.findOne({
      where :{
      detail : body.detail
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`Ya existe la información que desea ingresar.`
      });
    }

    const newType = new Type_Address_Medic( body );
    await newType.save();

    return res.json({
      ok: true,
      newType
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

const postPhone = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    //Validar que no exista otra data igual
    const existData = await Type_Phone_Medic.findOne({
      where :{
      detail : body.detail
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`Ya existe la información que desea ingresar.`
      });
    }

    const newType = new Type_Phone_Medic( body );
    await newType.save();

    return res.json({
      ok: true,
      newType
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

const postSpecialty = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    //Validar que no exista otra data igual
    const existData = await Specialty.findOne({
      where :{
      detail : body.detail
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`Ya existe la información que desea ingresar.`
      });
    }

    const newSpecialty = new Specialty( body );
    await newSpecialty.save();

    return res.json({
      ok: true,
      newSpecialty
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getAddress,
  getPhone,
  postAddress,
  postPhone,
  getSpecialty,
  postSpecialty
}
/* *************************************************************** */
/* *************************************************************** */