const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Exam = db.TypeExam;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getExam = async (req = request, res = response ) => { 
  try {

  const Exams = await Exam.findAll();

  return res.json({
    ok: true,
    Exams
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postExam = async (req = request, res = response ) => { 

  const { body } = req;

  body.id_user = req.uid;

  try {

    //Validar que no exista otra data igual
    const existData = await Exam.findOne({
      where :{
      detail : body.detail
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`Ya existe la información que desea ingresar.`
      });
    }

    const Object = new Exam( body );
    await Object.save();

  return res.json({
    ok: true,
    Object
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getExam,
  postExam
}
/* *************************************************************** */
/* *************************************************************** */