const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Sex = db.Sex;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getSex = async (req = request, res = response ) => { 
  try {

  const sex = await Sex.findAll();

  return res.json({
    ok: true,
    sex
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postSex = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    //Validar que no exista otra data igual
    const existData = await Sex.findOne({
      where :{
      detail : body.detail
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`Ya existe la información que desea ingresar.`
      });
    }

    const newSex = new Sex( body );
    await newSex.save();

  return res.json({
    ok: true,
    newSex
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putSex = async (req = request, res = response ) => { 

  const { id } = req.params.id;
  let { detail } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await Sex.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({detail});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deleteSex = async (req = request, res = response ) => { 

  const { id } = req.params.id;

  try {

    //Validar que exista la data para actualizar
    const existData = await Sex.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({status_sex: 0});

    return res.json({
      ok: true,
      msg: 'Información eliminada con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getSex,
  postSex,
  putSex,
  deleteSex
}
/* *************************************************************** */
/* *************************************************************** */