const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Record = db.RecordSubsequentQueries;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getRecord = async (req = request, res = response ) => { 
  const id_company = req.company;
  const dateObject = req.params.start;
  const dateObject2 = req.params.end;
  let start = new Date(dateObject);
  let end = new Date(dateObject2); 

  let {page, limit} = req.query;
  page = parseInt(page) || 0;
  limit = parseInt(limit) || 10;
  try {

  const records = await Record.findAll({
    where:{
      [Op.and]:[
        {create_time: {
          [Op.between]: [start, end]
        }}
      ]
    },
    order: [['name_patient', 'ASC']],
      limit,
      offset: page * limit,
      subQuery: false
  });

  return res.json({
    ok: true,
    records
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postRecord = async (req = request, res = response ) => { 

  const { body } = req;
  body.id_user = req.uid;

  try {

    const newRecord = new Record( body );
    await newRecord.save();

    return res.json({
      ok: true,
      newRecord
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getRecord,
  postRecord
}
/* *************************************************************** */
/* *************************************************************** */