const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Psychological = db.PsychologicalEvaluation;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getPsychological = async (req = request, res = response ) => { 
  const id_attention = req.params.id;
  try {

  const psychological = await Psychological.findOne({
    where: {
      id_attention
    }
  });

  return res.json({
    ok: true,
    psychological
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postPsychologicalEvaluation = async (req = request, res = response ) => { 

  const { body } = req;
  body.id_user = req.uid;
  body.id_psychological_evaluation = 0;

  try {

    //Validar que no exista otra data igual
    const existData = await Psychological.findOne({
      where :{
        id_attention : body.id_attention
    }
    });

    if(existData){
      await existData.update({assessment: body.assessment, clinical_evaluation: body.clinical_evaluation, psychological_instruments: body.psychological_instruments})
      return res.json({
        ok: true,
        msg:`Información actualizada con éxito.`
      });
    }

    const newPsychological = new Psychological( body );
    await newPsychological.save();

  return res.json({
    ok: true,
    msg:`Información guardada con éxito.`,
    newPsychological
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getPsychological,
  postPsychologicalEvaluation
}
/* *************************************************************** */
/* *************************************************************** */