const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Plan = db.TreatmentPlan;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getPlan = async (req = request, res = response ) => { 
  const id_attention = req.params.id
  try {

  const plan = await Plan.findOne({
    where:{
      id_attention
    }
  });

  return res.json({
    ok: true,
    plan
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postPlan = async (req = request, res = response ) => { 

  const { body } = req;
  body.id_user = req.uid;

  try {

    //Validar que no exista otra data igual
    const existData = await Plan.findOne({
      where:{
        id_attention: body.id_attention
      }
    });

    if(existData){
      const {treatment_plan} = req.body;
      await existData.update({treatment_plan});
      return res.json({
        ok: true,
      msg: 'Información actualizada con éxito.',
      });
    }

    const newPlan = new Plan( body );
    await newPlan.save();

  return res.json({
    ok: true,
    newPlan
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putPlan = async (req = request, res = response ) => { 

  const { id } = req.params.id;
  let { treatment_plan } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await Plan.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({treatment_plan});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deletePlan = async (req = request, res = response ) => { 

  const { id } = req.params.id;

  try {

    //Validar que exista la data para eliminar
    const existData = await Plan.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser eliminada.`
      });
    }

    await existData.update({status_treatment_plan: 0});

    return res.json({
      ok: true,
      msg: 'Información eliminada con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getPlan,
  postPlan,
  putPlan,
  deletePlan
}
/* *************************************************************** */
/* *************************************************************** */