const {response, request} = require('express');
const PDFDocument = require('pdfkit');
const fs = require('fs');
const path = require('path');
const { format, addDays } = require('date-fns');
const { es } = require('date-fns/locale');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');
const { birthDay } = require('../helpers/Pres_PDF');
const { fechaEnLetras, numeroEnLetras } = require('../helpers/db-validators');

const Prescription = db.Prescription;
const Attention = db.Attention;
const Patient = db.Patient;
const Diagnosis = db.Diagnosis;
const User = db.Users;
const Motive = db.ReasonConsultation;
const Plan = db.TreatmentPlan;
const Evolution = db.Evolution;
  

//! NO BORRAR SIRVE PARA VER LOS PDF EN POSTMAN SOLO REMPLAZAR CON EL RES.JSON EN EL CÓDIGO
  // const filename = `Receta_${Date.now()}.pdf`;
  // const stream = res.writeHead(200, {
  //   'Content-Type': 'application/pdf',
  //   'Content-disposition': `attachment;filename=${filename}`,
  // });

  // doc.on('data', (data) => {
  //   stream.write(data);
  // });

  // doc.on('end', () => {
  //   stream.end();
  // });
//!TODO: ESTE CÓDIGO HASTA AQUÍ

/* *************************************************************** */
/* **********************Services GET***************************** */

const getGeneratorPDF = async (req, res) => {
  const id_attention = req.params.id;

  const prescription = await Prescription.findAll({
    where: { id_attention },
  });

  const prescriptionJSON = prescription.map((prescription) => prescription.get({ plain: true }));
  let medical = prescriptionJSON
    .map((item, index, array) => {
      const line = `${index + 1}) ${item.medical}`;
      return index < array.length - 1 ? `${line}\n` : line;
    })
    .join('');

  let prescriber = prescriptionJSON
    .map((item, index, array) => {
      const line = `${index + 1}) ${item.prescriber}`;
      return index < array.length - 1 ? `${line}\n\n` : line;
    })
    .join('');

  const attention = await Attention.findByPk(id_attention);

  const patient = await Patient.findByPk(attention.id_patient);
  let sexo = '';
  if (patient.id_sex === 1) {
    sexo = 'Masculino';
  } else {
    sexo = 'Femenino';
  }

  const edad = await birthDay(patient.birthday);

  const diagnosis = await Diagnosis.findAll({
    where: { id_attention },
  });
  const diagnosisJSON = diagnosis.map((diagnosis) => diagnosis.get({ plain: true }));
  let cie = diagnosisJSON.map((i) => i.cie).join(' - ');

  const id_user = prescription[0].dataValues.id_user;
  const user = await User.findByPk(id_user);

  const pdfPath = path.join(__dirname, '../uploads/prescription', `Receta_${prescription[0].dataValues.id_prescription}.pdf`);
  const doc = new PDFDocument({ size: 'A4', layout: 'landscape', bufferPage: true });

  const widthRectTitle = 375;
  const headRectTitle = 20;
  const startRectTitle = 20;

  const actualityDate = new Date(prescription[0].dataValues.create_time);
  const day = actualityDate.getDate();
  const month = (actualityDate.getMonth() + 1).toString().padStart(2, '0');
  const year = actualityDate.getFullYear();

  // Set the response headers to force a download
  res.setHeader('Content-Disposition', `attachment; filename=Receta_${prescription[0].dataValues.id_prescription}.pdf`);
  res.setHeader('Content-Type', 'application/pdf');

  doc.on('end', () => {
    res.end(); // End the response when the PDF generation is complete
  });

  // Pipe the PDF document to the response (this will send the file to the client directly)
  doc.pipe(res);

  //? CABECERA DEL PDF 
  doc.moveDown();
  doc.font('Helvetica');
  doc.fontSize(12);
  doc.text('Servicio de Consulta Externa', 25, 120, {
    width: 200,
    align: 'left',
  });

  doc.text('Fecha ', 155, 120, {
    width: 225,
    align: 'center',
    continued: true,
  });
  doc.fontSize(5);
  doc.font('Helvetica-Bold').text('(día-mes-año)', 170, 123, {
    continued: true,
  });
  doc.font('Helvetica');
  doc.fontSize(12);
  doc.text(`: ${day}-${month}-${year}`, 205, 120);
  doc.rect(startRectTitle, 115, widthRectTitle, headRectTitle).stroke();

  //? DATOS DEL PACIENTE
  doc.font('Helvetica-Bold').text('Datos del paciente', 150, 140, {
    width: 370,
    align: 'left',
  });
  doc.font('Helvetica');
  doc.rect(startRectTitle, 135, widthRectTitle, headRectTitle).stroke();

  doc.fontSize(9);
  doc.text(`Apellidos y Nombre: ${patient.names_patient}`, 25, 160);
  doc.rect(startRectTitle, 155, widthRectTitle, headRectTitle - 5).stroke();

  doc.text(`Documento Identidad: ${patient.document_number}`, 25, 175);
  doc.text(`Edad: Años: ${edad.anios}, Meses:${edad.meses}.`, 185, 175);
  doc.text(`Sexo: ${sexo}`, 305, 175);
  doc.rect(startRectTitle, 170, widthRectTitle - 215, headRectTitle - 5).stroke();
  doc.rect(300, 170, widthRectTitle - 280, headRectTitle - 5).stroke();

  doc.text(`CIE-10: ${cie}`, 25, 190);
  doc.rect(startRectTitle, 185, widthRectTitle, headRectTitle - 5).stroke();

  //? DATOS DEL MEDICAMENTO
  doc.fontSize(11);
  doc.moveDown();
  doc.font('Helvetica-Bold').text('Datos del medicamento:', 25, 205);
  doc.font('Helvetica');

  const startMedicationDataY = 200;

  doc.fontSize(9);
  doc.text(`${medical}`);

  const rectHeight = 250;
  doc.rect(startRectTitle, 200, widthRectTitle, rectHeight).stroke();

  //? DATOS DEL PRESCRIPTOR
  const startPrescriberDataY = startMedicationDataY + 15 + rectHeight - 12;

  doc.fontSize(11);
  doc.font('Helvetica-Bold').text('Datos del Prescriptor:', 25, startPrescriberDataY);
  doc.font('Helvetica');

  const prescriberStaticInfoY = startPrescriberDataY;
  doc.fontSize(5);

  doc.fontSize(9);
  doc.text(`${user.name_person}`, 33, prescriberStaticInfoY + 20);
  doc.text(`${user.specialty}`, 33, prescriberStaticInfoY + 30);
  doc.text(`Cédula de Identidad: ${user.document_number}`, 33, prescriberStaticInfoY + 40);
  doc.text(`Unicodigo: ${user.unicodigo}`, 33, prescriberStaticInfoY + 50);

  const signatureY = prescriberStaticInfoY + 40;
  doc.fontSize(11);
  doc.font('Helvetica-Bold').text(`____________________________`, 202, signatureY);
  doc.text(`Firma y Sello`, 255, signatureY + 12);

  const prescriberSectionRectHeight = 75;
  doc.rect(startRectTitle, startPrescriberDataY - 3, widthRectTitle, prescriberSectionRectHeight).stroke();

  //? INDICACIONES
  const indicationsY = signatureY + 50;

  doc.font('Helvetica');

  doc.fontSize(9);
  doc.text(`${patient.names_patient} `, 520, 110, {
    align: 'left',
  });
  doc.text(`Fecha: ${day}-${month}-${year}`, 430, 140);

  doc.text(`${prescriber}`, 430, 180, {
    columns: 2,
    columnGap: 30,
    width: 465,
    align: 'left',
  });

  doc.end();
};




const getGeneratorPDF_HC = async (req, res) => {
  const id_attention = req.params.id;
  let count = 1;

  const attention = await Attention.findByPk(id_attention);
  const patient = await Patient.findByPk(attention.id_patient);
  let sexo = '';
  if (patient.id_sex === 1) {
    sexo = 'Masculino';
  } else {
    sexo = 'Femenino';
  }

  const edad = await birthDay(patient.birthday);

  let cie = 'No se ha detallado Información.';
  const diagnosis = await Diagnosis.findAll({
    where: { id_attention }
  });
  if (diagnosis[0]) {
    const diagnosisJSON = diagnosis.map(diagnosis => diagnosis.get({ plain: true }));
    cie = diagnosisJSON.map(i => `${i.cie}: ${i.diagnosis} // ${i.status_diagnosis === 1 ? 'Definitivo' : 'Presuntivo'}`).join('\n');
  }

  let reason = 'No se ha detallado Información.';
  let disease = 'No se ha detallado Información.';
  let treatment_plan = 'No se ha detallado Información.';

  const motive = await Motive.findOne({
    where: {
      id_attention
    }
  });

  if (motive) {
    reason = motive.reason;
    disease = motive.disease;
  }

  const plan = await Plan.findOne({
    where: {
      id_attention
    }
  });

  if (plan) {
    treatment_plan = plan.treatment_plan;
  }

  const evolution = await Evolution.findOne({
    where: {
      id_attention
    }
  });

  let evolution_evolution = 'No se ha detallado Información.';
  let prescription_evolution = 'No se ha detallado Información.';
  if (evolution) {
    evolution_evolution = evolution.evolution;
    prescription_evolution = evolution.prescriptions;
  }

  const user = await User.findByPk(attention.id_user);

  const doc = new PDFDocument({ bufferPage: true });

  const widthRectTitle = 490;
  const headRectTitle = 20;
  const startRectTitle = 60;

  const actualityDate = new Date(attention.create_time);
  const day = actualityDate.getDate();
  const month = (actualityDate.getMonth() + 1).toString().padStart(2, '0');
  const year = actualityDate.getFullYear();

  // Configuración de la respuesta para descarga directa
  res.setHeader('Content-Disposition', `attachment; filename=Atencion_${patient.names_patient}.pdf`);
  res.setHeader('Content-Type', 'application/pdf');

  doc.on('end', () => {
    res.end();
  });

  doc.pipe(res);  // Enviar el archivo directamente en el response

  //? CABECERA DEL PDF
  doc.fontSize(15);
  doc.moveDown();
  doc.font('Helvetica-Bold').text('CONSULTA EXTERNA', {
    width: 450,
    align: 'center'
  }, 105);
  doc.font('Helvetica');

  doc.fontSize(12);
  doc.text(`Profesional Responsable: ${user.name_person}`, 65, 130, {
    width: 450,
    align: 'left'
  });
  doc.rect(startRectTitle, 125, widthRectTitle, headRectTitle).stroke();

  doc.text('Servicio de Consulta Externa', 65, 150, {
    width: 225,
    align: 'center'
  });
  doc.rect(startRectTitle, 145, 240, headRectTitle).stroke();

  doc.text('Fecha ', 255, 150, {
    width: 225,
    align: 'center',
    continued: true
  });
  doc.fontSize(5);
  doc.font('Helvetica-Bold').text('(día-mes-año)', 269, 155, {
    width: 225,
    align: 'center',
    continued: true
  });
  doc.font('Helvetica');
  doc.fontSize(12);
  doc.text(`: ${day}-${month}-${year}`, 303, 150, {
    width: 225,
    align: 'center'
  });
  doc.rect(startRectTitle + 240, 145, 250, headRectTitle).stroke();

  // DATOS DEL PACIENTE
  doc.font('Helvetica-Bold').text('Datos del paciente', 65, 170, {
    align: 'left'
  });
  doc.font('Helvetica');
  doc.rect(startRectTitle, 165, widthRectTitle, headRectTitle).stroke();

  doc.fontSize(9);
  doc.text(`Apellidos y Nombre: ${patient.names_patient}`, 65, 190);
  doc.rect(startRectTitle, 185, widthRectTitle, headRectTitle - 5).stroke();

  doc.text(`Documento Identidad: ${patient.document_number}`, 65, 205);
  doc.rect(startRectTitle, 200, widthRectTitle - 330, headRectTitle - 5).stroke();

  doc.text(`Edad: Años: ${edad.anios}, Meses:${edad.meses}.`, 230, 205);
  doc.rect(220, 200, widthRectTitle - 360, headRectTitle - 5).stroke();

  doc.text(`Sexo: ${sexo}`, 365, 205);
  doc.rect(350, 200, widthRectTitle - 390, headRectTitle - 5).stroke();

  doc.text(`Página: ${count}`, 465, 205);
  doc.rect(450, 200, widthRectTitle - 390, headRectTitle - 5).stroke();

  const startCieDataY = 235;
  const cieData = `${cie}`;
  const cieDataHeight = doc.heightOfString(cieData, {
    width: widthRectTitle
  }) + 25;
  doc.fontSize(12);
  doc.font('Helvetica-Bold').text(`CIE-10:`, 65, 240);
  doc.font('Helvetica');
  doc.fontSize(9);
  doc.text(`${cie}`, 65, 255, { align: 'justify' });
  doc.rect(startRectTitle, startCieDataY, widthRectTitle, cieDataHeight).stroke();

  // Restante código para completar el PDF

  doc.end();
};


const getGeneratorPDF_Certificate = async (req, res) => {
  const { body } = req;
  const id_attention = body.id_attention;

  const attention = await Attention.findByPk(id_attention);
  const patient = await Patient.findByPk(attention.id_patient);
  let sexo = '';
  if (patient.id_sex === 1) {
    sexo = 'Masculino';
  } else {
    sexo = 'Femenino';
  }

  const edad = await birthDay(patient.birthday);

  let cie = 'No se a detallado Información.';
  const diagnosis = await Diagnosis.findAll({
    where: { id_attention }
  });
  if (diagnosis[0]) {
    const diagnosisJSON = diagnosis.map(diagnosis => diagnosis.get({ plain: true }));
    cie = diagnosisJSON.map(i => `${i.cie}: ${i.diagnosis}`).join('\n');
  }

  const user = await User.findByPk(attention.id_user);

  const doc = new PDFDocument({ bufferPage: true });

  const widthRectTitle = 490;
  const headRectTitle = 20;
  const startRectTitle = 55;

  const actualityDate = new Date(attention.create_time);
  const fechaFormateada = format(actualityDate, "dd/MM/yyyy EEEE dd 'DE' MMMM 'DE' yyyy", { locale: es });
  const fechaFormateadaLetras = format(actualityDate, "EEEE dd 'DE' MMMM 'DE' yyyy", { locale: es });
  const fechaManana = addDays(actualityDate, body.rest_days - 1);
  const fechaFormateadaMañana = format(fechaManana, "dd/MM/yyyy EEEE dd 'DE' MMMM 'DE' yyyy", { locale: es });
  let day = actualityDate.getDate();
  const month = (actualityDate.getMonth() + 1).toString().padStart(2, '0');
  const year = actualityDate.getFullYear();
  if (parseInt(day) < 10) {
    day = "0" + day;
  }

  // Obtener la hora actual
  const hora = String(actualityDate.getHours()).padStart(2, '0');
  const minutos = String(actualityDate.getMinutes()).padStart(2, '0');

  actualityDate.setHours(actualityDate.getHours() + 1);

  // Obtener la nueva hora después de sumar una hora
  const nuevaHora = String(actualityDate.getHours()).padStart(2, '0');
  const nuevosMinutos = String(actualityDate.getMinutes()).padStart(2, '0');

  const startDate = await fechaEnLetras(attention.create_time);
  const rest_days_letters = await numeroEnLetras(body.rest_days);

  // Configuración de la respuesta para descarga directa
  res.setHeader('Content-Disposition', `attachment; filename=Certificado_${patient.names_patient}.pdf`);
  res.setHeader('Content-Type', 'application/pdf');

  doc.on('end', () => {
    res.end();  // Finaliza la respuesta y envía el archivo
  });

  doc.pipe(res);  // Enviar el archivo directamente en el response

  //? CABECERA DEL PDF 
  doc.fontSize(15);
  doc.moveDown();
  doc.font('Helvetica-Bold').text('CERTIFICADO MÉDICO', {
    width: 450,
    align: 'center'
  }, 105);
  doc.font('Helvetica');

  doc.fontSize(11);
  doc.text(`Certifico que ${patient.names_patient} C.I. N° ${patient.document_number}, con la Historia Clínica N° ${patient.document_number}. Fue atendido en el servicio de consulta externa en mi consultorio privado. Desde el ${day}/${month}/${year} (${startDate}) a las ${hora}:${minutos}, hasta el ${day}/${month}/${year} (${startDate}) a las ${nuevaHora}:${nuevosMinutos}\n\nCon CIE-10:\n\n${cie}\n\nPor tanto se prescribe ${body.rest_days} (${rest_days_letters}) día(s) de reposo, a partir del: ${fechaFormateada.toUpperCase()}, hasta el: ${fechaFormateadaMañana.toUpperCase()}.\n\nOBSERVACIONES: ${body.observations}\nACTIVIDAD LABORAL: ${body.work_activity}.\nNOMBRE EMPRESA: ${body.work}.\nTIPO DE CONTINGENCIA: ${body.contingency_type}\nDIRECCIÓN DOMICILIARIA: ${patient.address_patient}\nTELÉFONO DE CONTACTO: ${patient.phone}\n\nAtentamente:`, 65, 180, {
    width: 470,
    align: 'justify',
    continued: true
  });
  doc.fontSize(9);
  doc.text(`D.M. de Quito, ${fechaFormateadaLetras.toUpperCase()}`, {
    align: 'right'
  });
  doc.fontSize(11);
  doc.text(`\n\n\n\n\n__________________________________\nMédico: ${user.name_person}\nIdentificación: ${user.document_number}\nEspecialidad: ${user.specialty}\nEmail: ${user.email}\nTeléfono: ${user.phone_person}`, {
    align: 'left',
    continued: true
  });

  doc.end();
};



/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getGeneratorPDF,
  getGeneratorPDF_HC,
  getGeneratorPDF_Certificate
}
/* *************************************************************** */
/* *************************************************************** */