const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Diagnosis = db.Diagnosis;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getDiagnosis = async (req = request, res = response ) => { 

  const id_attention = req.params.id;

  try {

    const diagnosis = await Diagnosis.findAll({
      where:{
        id_attention
      }
    });

    return res.json({
      ok: true,
      diagnosis
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postDiagnosis = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    const id_attention = body.dynamics[0].id_attention
    await Diagnosis.destroy({
      where: {
        id_attention
      }
    });

    body.dynamics.forEach( element => {
      const newDiagnosis = new Diagnosis( element );
      newDiagnosis.id_user = req.uid;
      newDiagnosis.save();      
    });

    return res.json({
      ok: true,
      msg: 'La información se almaceno con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */
const putDiagnosis = async (req = request, res = response ) => { 

  const { id } = req.params.id;
  let { cie, diagnosis } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await Diagnosis.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({cie, diagnosis});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deleteDiagnosis = async (req = request, res = response ) => { 

  const { id } = req.params.id;

  try {

    //Validar que exista la data para eliminar
    const existData = await Diagnosis.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser eliminada.`
      });
    }

    await existData.update({status_diagnosis: 0});

    return res.json({
      ok: true,
      msg: 'Información eliminada con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getDiagnosis,
  postDiagnosis,
  putDiagnosis,
  deleteDiagnosis
}
/* *************************************************************** */
/* *************************************************************** */