
const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const CivilStatus = db.CivilStatus;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getCivilStatus = async (req = request, res = response ) => { 
  try {

  const civilStatus = await CivilStatus.findAll();

  return res.json({
    ok: true,
    civilStatus
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postCivilStatus = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    //Validar que no exista otra data igual
    const existData = await CivilStatus.findOne({
      where :{
      detail : body.detail
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`Ya existe la información que desea ingresar.`
      });
    }

    const newCivilStatus = new CivilStatus( body );
    await newCivilStatus.save();

  return res.json({
    ok: true,
    newCivilStatus
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putCivilStatus = async (req = request, res = response ) => { 

  const { id } = req.params.id;
  let { detail, description_civil_status } = req.body;

  try {

    //Validar que exista la data para actualizar
    const existData = await CivilStatus.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser actualizada.`
      });
    }

    await existData.update({detail, description_civil_status});

    return res.json({
      ok: true,
      msg: 'Información actualizada con éxito.',
      existData
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deleteCivilStatus = async (req = request, res = response ) => { 

  const { id } = req.params.id;

  try {

    //Validar que exista la data para eliminada
    const existData = await CivilStatus.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser eliminada.`
      });
    }

    await existData.update({status_civil_status: 0});

    return res.json({
      ok: true,
      msg: 'Información eliminada con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getCivilStatus,
  postCivilStatus,
  putCivilStatus,
  deleteCivilStatus
}
/* *************************************************************** */
/* *************************************************************** */