const {response, request} = require('express');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Boxes = db.Boxes;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getBoxes = async (req = request, res = response ) => { 
  const id_company = req.company;
  try {

  const boxes = await Boxes.findAll({
    where:{
      id_company
    }
  });

  return res.json({
    ok: true,
    boxes
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postBox = async (req = request, res = response ) => { 

  const { body, company } = req;


  try {

    //Validar que no exista otra data igual
    const existData = await Boxes.findOne({
      where :{
        [Op.and]:[
          {id_company: company},
          {emission_point : body.emission_point},
          {establishment_code: body.establishment_code}
        ]
    }
    });

    if(existData){
      return res.status(409).json({
        ok: false,
        msg:`Caja con la secuencia ${body.establishment_code}-${body.emission_point}, ya se encuentra registrada.`
      });
    }

    const newBox = new Boxes( body );
    await newBox.save();

  return res.json({
    ok: true,
    newBox
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */

const deleteBox = async (req = request, res = response ) => { 

  const { id } = req.params.id;

  try {

    //Validar que exista la data para eliminar
    const existData = await Boxes.findByPK( id );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe información para ser eliminada.`
      });
    }

    await existData.update({status_box: 0});

    return res.json({
      ok: true,
      msg: 'Información eliminada con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getBoxes,
  postBox,
  deleteBox
}
/* *************************************************************** */
/* *************************************************************** */