const {response, request} = require('express');
// const fechaActualEnQuito = moment().tz('America/Guayaquil').format('YYYY-MM-DD HH:mm:ss');

const { Op } = require("sequelize");

const {db} = require('../tables_db/init-models');

const Attention = db.Attention;
const Patient_Company = db.Patient_Company;

/* *************************************************************** */
/* **********************Services GET***************************** */

const getAttentionActivate = async (req = request, res = response ) => { 
  const id_patient = req.params.id;
  const id_company = req.company;
  try {

  const attention = await Attention.findOne({
    where:{
      [Op.and]:[
        {id_patient},
        {id_company},
        {status_attention: 1}
      ]
    }
  });

  return res.json({
    ok: true,
    attention
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};
const getAttentions = async (req = request, res = response ) => { 
  const id_patient = req.params.id;
  const id_company = req.company;
  try {

  const attention = await Attention.findAll({
    where:{
      [Op.and]:[
        {id_patient},
        {id_company}
      ]
    }
  });

  return res.json({
    ok: true,
    attention
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

const getTotalAttention = async (req = request, res = response ) => { 
  const id = req.params.id;
  try {

  const data = await Attention.findOne({
    where:{
      id_attention : id
    }
  });

  if(!data){
    return res.status(404).json({
      ok: false,
      msg:"El paciente no tiene atenciones."
    });
  }

  const attentions = await Attention.findAndCountAll({
    where:{
      id_patient: data.id_patient
    },
    order:[
      ['create_time','DESC']
    ]
  })

  return res.json({
    ok: true,
    attentions
  });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

const getAttentionWeek = async (req = request, res = response ) => { 
  const id_company = req.company;
  try {

    const today = new Date();
    const startDate = new Date(today.getFullYear(), today.getMonth(), today.getDate());
    const endDate = new Date(today.getFullYear(), today.getMonth(), today.getDate() + 1);
    const firstDayOfWeek = new Date(today.getFullYear(), today.getMonth(), today.getDate() - today.getDay());
    const firstDayOfMonth = new Date(today.getFullYear(), today.getMonth(), 1);
    const lastDayOfMonth = new Date(today.getFullYear(), today.getMonth() + 1, 0);

    const attention = {
      diaActual: await Attention.count({
        where: {
          [Op.and]:[
            {id_company},
            {create_time: {
              [Op.between]: [startDate, endDate]
            }}
          ]
        }
      }),
      semanaActual: await Attention.count({
        where: {
          [Op.and]:[
            {id_company},
            {create_time: {
              [Op.gte]: firstDayOfWeek
            }}
          ]
        }
      }),
      anioActual: await Attention.count({
        where: {
          [Op.and]:[
            {id_company},
            {create_time: {
              [Op.between]: [firstDayOfMonth, lastDayOfMonth]
            }}
          ]
        }
      }),
      pacientes: await Patient_Company.count({
        where:{
          id_company
        }
      })
    };

    return res.json({
      ok: true,
      attention
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services POST**************************** */

const postAttention = async (req = request, res = response ) => { 

  const { body } = req;
  body.id_user = req.uid;
  body.id_company = req.company;
  
  try {

    const activateAttention = await Attention.findOne({
      where:{
        [Op.and]:[
          {id_company: body.id_company},
          {id_patient: body.id_patient},
          {status_attention: 1}
        ]
      }
    })

    if(activateAttention){
      return res.status(401).json({
        ok: false,
        msg: 'El paciente cuenta con una atención que no ha sido facturada aún.',
        id: activateAttention.id_attention
      });
    }

    const newAttention = new Attention( body );
    await newAttention.save();

    return res.json({
      ok: true,
      newAttention
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services PUT***************************** */

const putAttention = async (req = request, res = response ) => { 

  const { body } = req;

  try {

    //Validar que exista la data para eliminar
    const existData = await Attention.findByPk( body.id_attention );

    if(!existData){
      return res.status(400).json({
        ok: false,
        msg:`No existe atención para ser concluida.`
      });
    }

    await existData.update({status_attention: body.status_attention, observation: body.observation});

    return res.json({
      ok: true,
      msg: 'Atención cerrada con éxito.'
    });

  } catch (error) {
    console.log(error);
    return res.status(500).json({
      ok:false,
      msg: error
    });
  }
};

/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* **********************Services DELETE************************** */


/* *************************************************************** */
/* *************************************************************** */


/* *************************************************************** */
/* ***************************EXPORTS***************************** */

module.exports = {
  getAttentions,
  getAttentionActivate,
  getTotalAttention,
  getAttentionWeek,
  postAttention,
  putAttention
}
/* *************************************************************** */
/* *************************************************************** */